import argparse
import torch
import numpy as np
import random
from trainers.train_sdf_from7000 import training_with_sdf_regularization

class AttrDict(dict):
        def __init__(self, *args, **kwargs):
            super().__init__(*args, **kwargs)
            self.__dict__ = self


if __name__ == "__main__":
    # ours: fixed random seed
    # seed = 1
    # torch.manual_seed(seed)
    # torch.cuda.manual_seed(seed)
    # np.random.seed(seed)
    # random.seed(seed)
    # torch.backends.cudnn.deterministic = True
    # ----- Parser -----
    parser = argparse.ArgumentParser(description='Script to optimize a full GSPull model.')
    args = parser.parse_args()

    coarse_args = AttrDict({
        'checkpoint_path': args.checkpoint_path,
        'scene_path': args.scene_path,
        'iteration_to_load': args.iteration_to_load,
        'output_dir': args.output,
        'eval': args.eval,
        'gpu': args.gpu,
        'dataset_name': args.dataset_name,
        'white_bg': args.is_black_bg,
        'image_resolution': args.resolution,
    })
    training_with_sdf_regularization(args)
